<?php

namespace console\controllers;

use yii\console\Controller;
use Yii;
use backend\models\Dnsbl;
use yii\db\Expression;
use yii\validators\IpValidator;
use yii\helpers\ArrayHelper;


class DnsblController extends Controller
{
    public function actionIndex()
    {
        $validator = new IpValidator();

        $res = [];

        $l0 = 'http://wget-mirrors.uceprotect.net/rbldnsd-all/';
        $l1 = ['dnsbl-1.uceprotect.net','dnsbl-2.uceprotect.net','dnsbl-3.uceprotect.net'];

        foreach ($l1 as $ke => $va) {
            if(file_exists($va)){
                unlink($va);
            }
            
            $e = shell_exec('wget '.$l0.$va.'.gz');
            $e = shell_exec('7za e '.$va.'.gz');
            unlink($va.'.gz');
        }

        foreach ($l1 as $ke => $va) {
            
            $la1 = file($va);
            foreach ($la1 as $key => $value) {
                $s1 = trim(str_replace('!', '', explode(' ', $value)[0]));
                $s2 = explode('/',$s1);
                if($validator->validate($s2[0])){
                    if(isset($s2[1])){
                        $ip = $this->ipRange($s2[0].'/'.$s2[1]);
                    }else{
                        $ip = $this->ipRange($s2[0].'/32');
                    }
                    //$ipn[0] = ip2long($ip[0]);
                    //$ipn[1] = ip2long($ip[1]);

                    array_push($res, $ip);
                }
            }
            unlink($va);
        
        }
        file_put_contents('dnsbl.json', json_encode($res));
        
        exit();
    }

    public function ipRange($cidr) {
        $range = array();
        $cidr = explode('/', $cidr);
        $range[0] = long2ip((ip2long($cidr[0])) & ((-1 << (32 - (int)$cidr[1]))));
            
        if(isset($cidr[1])){
            $range[1] = long2ip((ip2long($range[0])) + pow(2, (32 - (int)$cidr[1])) - 1);
        }else{
            $range[1] = $range[0];
        }
        return $range;
    }

}
